#include <stdio.h>
#include <string.h>

#define MAXN 200005

int N, Q;
int a[MAXN];
int cnt_total[MAXN], cnt_pref[MAXN];
long long BIT[MAXN];
int curr_k = 0;

/* Fenwick */
void bit_add(int i, long long v) {
    for (; i <= N; i += i & -i)
        BIT[i] += v;
}

long long bit_sum(int i) {
    long long s = 0;
    for (; i > 0; i -= i & -i)
        s += BIT[i];
    return s;
}

/* ukloni stari doprinos i dodaj novi */
void update_value(int x, int old_pref, int new_pref) {
    int total = cnt_total[x];

    if (old_pref == total && (old_pref & 1))
        bit_add(x, -x);

    if (new_pref == total && (new_pref & 1))
        bit_add(x, x);
}

int main() {
    scanf("%d %d", &N, &Q);
    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        cnt_total[a[i]]++;
    }

    while (Q--) {
        int t;
        scanf("%d", &t);

        if (t == 1) {
            int x;
            scanf("%d", &x);

            while (curr_k < x) {
                curr_k++;
                int v = a[curr_k];
                update_value(v, cnt_pref[v], cnt_pref[v] + 1);
                cnt_pref[v]++;
            }
            while (curr_k > x) {
                int v = a[curr_k];
                update_value(v, cnt_pref[v], cnt_pref[v] - 1);
                cnt_pref[v]--;
                curr_k--;
            }

            printf("%lld\n", bit_sum(N));
        } else {
            int pos, val;
            scanf("%d %d", &pos, &val);

            int old = a[pos];
            if (pos <= curr_k) {
                update_value(old, cnt_pref[old], cnt_pref[old] - 1);
                cnt_pref[old]--;
            }
            cnt_total[old]--;

            a[pos] = val;
            cnt_total[val]++;

            if (pos <= curr_k) {
                update_value(val, cnt_pref[val], cnt_pref[val] + 1);
                cnt_pref[val]++;
            }
        }
    }

    return 0;
}